/*
 * Decompiled with CFR 0.152.
 */
package be.wwx.hibernate;

import be.wwx.hibernate.a;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin
implements Listener {
    private FileConfiguration a = this.getConfig();
    private static boolean b = false;

    public void onDisable() {
        try {
            Bukkit.getScheduler().cancelTasks((Plugin)this);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onEnable() {
        Plugin[] pluginArray;
        this.saveDefaultConfig();
        this.a.addDefault("enabled", (Object)Boolean.TRUE);
        this.a.addDefault("unloadChunks", (Object)Boolean.TRUE);
        this.a.addDefault("sleepMillis", (Object)1000L);
        this.a.addDefault("blacklist", new ArrayList());
        this.a.options().copyDefaults(true);
        be.wwx.hibernate.a.a = true;
        be.wwx.hibernate.a.b = this.a.getBoolean("unloadChunks");
        be.wwx.hibernate.a.c = this.a.getLong("sleepMillis");
        be.wwx.hibernate.a.d = this.a(this.a);
        this.getConfig().set("enabled", (Object)true);
        this.saveConfig();
        HashSet<String> hashSet = new HashSet<String>();
        for (Plugin plugin : pluginArray = this.getServer().getPluginManager().getPlugins()) {
            if (!be.wwx.hibernate.a.d.contains(plugin.getName().toLowerCase())) continue;
            hashSet.add(plugin.getName());
        }
        if (hashSet.isEmpty()) {
            Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, () -> {
                Server server = Bukkit.getServer();
                int n = server.getOnlinePlayers().size();
                if (n == 0 && be.wwx.hibernate.a.a) {
                    if (be.wwx.hibernate.a.e == 0) {
                        try {
                            Thread.sleep(be.wwx.hibernate.a.c);
                            this.unloadAllChunks();
                        }
                        catch (Exception exception) {}
                    } else {
                        this.getLogger().info("Saving worlds before Hibernation");
                        for (World world : server.getWorlds()) {
                            world.save();
                        }
                        this.getLogger().info("Worlds saved!");
                        be.wwx.hibernate.a.e = 0;
                    }
                } else {
                    be.wwx.hibernate.a.e = n;
                }
            }, 0L, 1L);
            b = true;
        } else {
            this.getLogger().warning("Blacklisted plugins detected, disabling standard hibernation.");
            this.getLogger().warning("Blacklisted plugins: " + String.join((CharSequence)", ", hashSet));
        }
        if (be.wwx.hibernate.a.b) {
            this.unloadAllChunks();
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("Hibernate is active and always enabled.");
    }

    private Set<String> a(FileConfiguration fileConfiguration) {
        HashSet hashSet = new HashSet(fileConfiguration.getStringList("blacklist"));
        HashSet<String> hashSet2 = new HashSet<String>();
        for (String string : hashSet) {
            if (string.startsWith("http")) {
                try {
                    Scanner scanner = new Scanner(new URL(string).openStream(), "UTF-8");
                    Throwable throwable = null;
                    try {
                        while (scanner.hasNextLine()) {
                            String string2 = scanner.nextLine();
                            if (string2.isEmpty() || string2.startsWith("#")) continue;
                            hashSet2.add(string2.toLowerCase());
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (scanner == null) continue;
                        if (throwable != null) {
                            try {
                                scanner.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        scanner.close();
                    }
                }
                catch (IOException iOException) {
                    this.getLogger().severe("Failed to get blacklist from URL: " + string);
                }
                continue;
            }
            hashSet2.add(string.toLowerCase());
        }
        return hashSet2;
    }

    private void unloadAllChunks() {
        int n = 0;
        for (World world : Bukkit.getWorlds()) {
            for (Chunk chunk : world.getLoadedChunks()) {
                if (!chunk.unload(true)) continue;
                ++n;
            }
        }
        if (n > 0) {
            this.getLogger().info(String.format("Unloaded %d chunks", n));
            this.runGarbageCollector();
        }
    }

    private void runGarbageCollector() {
        long l = Runtime.getRuntime().freeMemory();
        System.gc();
        long l2 = (Runtime.getRuntime().freeMemory() - l) / 1024L / 1024L;
        if (l2 > 0L) {
            this.getLogger().info(String.format("%d MB memory freed using Java garbage collector", l2));
        }
    }
}

